﻿<%@ import Namespace="System.Diagnostics" %>
<%@ import Namespace="System.Collections.Generic" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Place" %>
<%@ import Namespace="Soneta.Core" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Tools" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Page Language="c#" autoeventwireup="false" CodePage="1200" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Zestawienie list płac</title>
		<script runat="server">

	//Max długość opisu z numerami list płac. 
	// 0: bez limitu.
	//-1: nie drukuj listy numerów na podsumowaniu
	static int maxOpisLen = 0;

            class TotalKey {

                enum Level {
                    Nieopodatkowany,
                    Opodatkowany,
                    Zdrow,
                    ZUS
                }

                readonly DefinicjaElementu definicja;
                readonly Level level;

                public TotalKey(DefinicjaElementu definicja) {
                    this.definicja = definicja;

                    if (definicja.Info.PodstawaZUS)
                        this.level = Level.ZUS;
                    else if (definicja.Info.PodstawaZdrow)
                        this.level = Level.Zdrow;
                    else if (definicja.Info.Opodatkowany)
                        this.level = Level.Opodatkowany;
                    else
                        this.level = Level.Nieopodatkowany;
                }

                public TotalKey(WypElement e) {
                    this.definicja = e.Definicja;

                    if (e.PodstawaZUS)
                        this.level = Level.ZUS;
                    else if (e.PodstawaZdrow)
                        this.level = Level.Zdrow;
                    else if (e.PodstawaFIS)
                        this.level = Level.Opodatkowany;
                    else
                        this.level = Level.Nieopodatkowany;
                }

                public override int GetHashCode() {
                    return definicja.GetHashCode() ^ 17 * level.GetHashCode();
                }
                public override bool Equals(object obj) {
                    TotalKey key = obj as TotalKey;
                    if (key == null)
                        return false;
                    return this.definicja == key.definicja && this.level == key.level;
                }
            }

            class Total : IComparable {
                readonly WypElement element;
                readonly string nazwa;
                readonly bool zasiłek;
                int liczbaOP;
                decimal wartośćDodOP;
                decimal wartośćPotrOP;
                int liczbaNp;
                decimal wartośćDodNp;
                decimal wartośćPotrNp;
                decimal doOpodatkowania;
                decimal przychod26;
                public Total(WypElement element, string nazwa) {
                    this.element = element;
                    this.zasiłek = element.ZasiłekBudżet || element.ZasiłekZus;
                    this.nazwa = nazwa;
                }
                public void Add(WypElement element) {
                    doOpodatkowania += element.Podatki.ZUS;
                    decimal op = element.DoOpodatkowania;
                    przychod26 += element.Podatki.Przychod26;
                    if (op != 0) {
                        if (op > 0)
                            wartośćDodOP += op;
                        else
                            wartośćPotrOP += op;
                        liczbaOP++;
                    }                    
                    decimal np = element.NiePodlegaOpodatkowaniu;
                    if (np != 0) {
                        if (np > 0)
                            wartośćDodNp += np;
                        else
                            wartośćPotrNp += np;
                        liczbaNp++;
                    }
                }
                public int CompareTo(object v) {
                    return string.Compare(Nazwa, ((Total)v).Nazwa, true);
                }
                public bool PodstawaFIS {
                    get { return element.PodstawaFIS; }
                }
                public bool PodstawaZUS {
                    get { return element.PodstawaZUS; }
                }
                public bool PodstawaZdrow {
                    get { return element.PodstawaZdrow; }
                }
                public bool Zasiłek {
                    get { return zasiłek; }
                }
                public string Nazwa {
                    get { return nazwa; }
                }
                public int LiczbaOP {
                    get { return liczbaOP; }
                }
                public decimal DodatkiOP {
                    get { return wartośćDodOP; }
                }
                public decimal PotrąceniaOP {
                    get { return -wartośćPotrOP; }
                }
                public decimal RazemOP {
                    get { return wartośćDodOP + wartośćPotrOP; }
                }
                public int LiczbaNp {
                    get { return liczbaNp; }
                }
                public decimal DodatkiNp {
                    get { return wartośćDodNp; }
                }
                public decimal PotrąceniaNp {
                    get { return -wartośćPotrNp; }
                }
                public decimal RazemNp {
                    get { return wartośćDodNp + wartośćPotrNp; }
                }
                public decimal DoOpodatkowania {
                    get { return doOpodatkowania; }
                }
                public decimal Przychod26 {
                    get { return przychod26; }
                }
            }

            class Składka {
                string nazwa;
                decimal podstawa;
                decimal prac;
                decimal firma;
                public Składka(string nazwa) {
                    this.nazwa = nazwa;
                }
                public void Add(ISkładka składka) {
                    podstawa += składka.Podstawa;
                    prac += składka.Prac;
                    firma += składka.Firma;
                }
                public void Add(decimal podstawa, decimal prac, decimal firma) {
                    this.podstawa += podstawa;
                    this.prac += prac;
                    this.firma += firma;
                }
                public string Nazwa {
                    get { return nazwa; }
                }
                public decimal Podstawa {
                    get { return podstawa; }
                }
                public decimal Prac {
                    get { return prac; }
                }
                public decimal Firma {
                    get { return firma; }
                }
                public decimal Razem {
                    get { return prac + firma; }
                }
            }

            class Kwota {
                string nazwa;
                decimal wartość;
                public Kwota(string nazwa) {
                    this.nazwa = nazwa;
                }
                public void Add(decimal wartość) {
                    this.wartość += wartość;
                }
                public string Nazwa {
                    get { return nazwa; }
                }
                public decimal Wartość {
                    get { return wartość; }
                }
            }

            class Wypłata {
                readonly string waluta;
                double kurs = 0;
                Currency gotówka = Currency.Empty;
                Currency przelew = Currency.Empty;
                public Currency gotówkaPLN = Currency.Zero;
                public Currency przelewPLN = Currency.Zero;
                public int lp;
                public Wypłata(string waluta) {
                    this.waluta = waluta;
                }
                public Wypłata(string waluta, Currency gotówka, Currency przelew): this(waluta) {
                    this.gotówka = gotówka;
                    this.przelew = przelew;
                }
                public void Add(Wyplata wypłata) {
                    foreach (Soneta.Kasa.Platnosc p in wypłata.Platnosci) {
                        Currency kwota = p.Kwota;
                        Currency kwotaPLN = p.Kwota;
                        if (kwotaPLN.Symbol != Currency.SystemSymbol && wypłata.Kurs != 0) {
                            kwotaPLN = kwotaPLN.Value * (decimal)wypłata.Kurs;
                            if (kurs == 0)
                                kurs = wypłata.Kurs;
                            else if (kurs != wypłata.Kurs)
                                kurs = -1;
                        }
                        
                        if (p.SposobZaplaty.Typ == Soneta.Kasa.TypySposobowZaplaty.Gotówka) {
                            gotówka = gotówka.AddExt(Wartość(p, kwota));
                            gotówkaPLN += Wartość(p, kwotaPLN);
                        }
                        else {
                            przelew = przelew.AddExt(kwota);
                            przelewPLN += Wartość(p, kwotaPLN);
                        }
                        if (waluta != Currency.SystemSymbol && kurs == 0 && p.Kurs != 0)
                            kurs = p.Kurs;
                    }
                }
                public int Lp {
                    get { return lp; }
                }
                public string Waluta {
                    get { return waluta; }
                }
                public string Info {
                    get { 
                        if (kurs==0 || kurs==1)
                            return waluta;
                        return string.Format("{0} (kurs {1})", waluta, kurs!=-1 ? kurs.ToString() : "?");
                    }
                }
                public Currency Razem {
                    get { return gotówka.AddExt(przelew); }
                }
                public Currency Gotówka {
                    get { return gotówka; }
                }
                public Currency Przelew {
                    get { return przelew; }
                }

                static Currency Wartość(Soneta.Kasa.Platnosc płatność, Currency kwota) {
                    return płatność is Soneta.Kasa.Zobowiazanie ? kwota : -kwota;
                }
            }

            class PodsumowanieVAT: IComparable<PodsumowanieVAT> {
                DefinicjaStawkiVat definicjaStawki;
                decimal netto, vat;
                public PodsumowanieVAT(DefinicjaStawkiVat definicjaStawki) {
                    this.definicjaStawki = definicjaStawki;
                }
                public void Add(WypElement element) {
                    if (element.Podatki.VAT.DefinicjaStawki != definicjaStawki)
                        throw new ArgumentException("Element z niezgodną definicją stawki VAT " + element + ".");
                    netto += element.Podatki.VAT.Podstawa;
                    vat += element.Podatki.VAT.Podatek;
                }
                public DefinicjaStawkiVat Stawka {
                    get { return definicjaStawki; }
                }

                public decimal Netto {
                    get { return netto; }
                }
                public decimal VAT {
                    get { return vat; }
                }
                public decimal Brutto {
                    get { return netto + vat; }
                }
                public int CompareTo(PodsumowanieVAT other) {
                    if (other == null)
                        return 1;
                    return definicjaStawki.Kod.CompareTo(other.definicjaStawki.Kod);
                }
            }

            class LiczbaElementow {
                readonly string opis;
                readonly int liczba;
                public LiczbaElementow(string opis, int liczba) {
                    this.opis = opis;
                    this.liczba = liczba;
                }
                public string Opis {
                    get { return opis; }
                }

                public int Liczba {
                    get { return liczba; }
                }
            }

            class Podsumowanie {

                readonly PrnParams pars;
                readonly SrParams srpars;
                int clisty = 0;
                int cwyplaty = 0;
                int celementy = 0;
                Hashtable pracownicy = new Hashtable();
                ListaPlac lista;
                string listy = "";
                Dictionary<TotalKey, Total> ht = new Dictionary<TotalKey, Total>();
                Składka[] składkiZUS = new Składka[4];
                Składka[] składkiNFZ = new Składka[2];
                Składka[] składkiPPK = new Składka[1];
                Składka[] składkiPoz = new Składka[3];
                Kwota[] podatki = new Kwota[20];
                List<Wypłata> wypłaty = new List<Wypłata>();
                Dictionary<string, Wypłata> wypłatyDct = new Dictionary<string, Wypłata>();
                ArrayList opodatkowaneZUS;
                decimal sumaPrzychod26 = 0;

                ArrayList opodatkowaneZdrow;
                ArrayList opodatkowane;
                ArrayList zasiłki;
                ArrayList nieOpodatkowanePodst;
                ArrayList nieOpodatkowane;
                ArrayList nieOpZasiłki;
                List<PodsumowanieVAT> podatekVAT;
                Dictionary<DefinicjaStawkiVat, PodsumowanieVAT> podsumowanieVAT = new Dictionary<DefinicjaStawkiVat, PodsumowanieVAT>();
                bool ppk;

                private bool JestPPK(ISessionable session, Date data) {
        YearMonth podlegaOd = PlaceModule.GetInstance(session).Config.PracowniczePlanyKapitałowe.Ogólne.PodlegaOd;
        return podlegaOd != YearMonth.Empty ? new FromTo(podlegaOd.FirstDay, Date.MaxValue).Contains(data) : false;
     }

                public Podsumowanie(ListaPlac lista, PrnParams pars, SrParams srpars) {
                    this.pars = pars;
                    this.srpars = srpars;
                    this.lista = lista;

                    składkiZUS[0] = new Składka("Ubezpieczenie emerytalne");
                    składkiZUS[1] = new Składka("Ubezpieczenie rentowe");
                    składkiZUS[2] = new Składka("Ubezpieczenie chorobowe");
                    składkiZUS[3] = new Składka("Ubezpieczenie wypadkowe");

                    składkiNFZ[0] = new Składka("Składka");
                    składkiNFZ[1] = new Składka("Do odliczenia od zaliczki na podatek");
                    //składkiNFZ[2] = new Składka("Do odliczenia od wynagrodzenia netto");

                    składkiPPK[0] = new Składka("Składka");

                    składkiPoz[0] = new Składka("Fundusz Pracy");
                    składkiPoz[1] = new Składka("Fundusz Gwarant.Świadczeń Pracow.");
                    składkiPoz[2] = new Składka("Fundusz Emerytur Pomostowych");

                    podatki[0] = new Kwota("Przychód");
                    podatki[1] = new Kwota("Przychód zw. art. 21 u.z p. 148");
                    podatki[2] = new Kwota("Suma składek ZUS (pomn. podst. opodatkowania)");
                    podatki[3] = new Kwota("Suma składek ZUS (nie pomn. podst. opodatkowania)");
                    podatki[4] = new Kwota("Suma składek ZUS (ogółem)");
                    podatki[5] = new Kwota("Koszty uzyskania");
                    podatki[6] = new Kwota("Suma składek pracodawcy na PPK (powiększa podst.opodatkowania)");
                    podatki[7] = new Kwota("Ulga podatkowa");
                    podatki[8] = new Kwota("Podatek naliczony");
                    podatki[9] = new Kwota("Naliczona zaliczka podatku (wynagrodzenia)");
                    podatki[10] = new Kwota("Naliczona zaliczka podatku (zasiłki)");
                    podatki[11] = new Kwota("Zdrowotne do odliczenia");
                    podatki[12] = new Kwota("Zaniechanie poboru zaliczki");
                    podatki[13] = new Kwota("Zaliczka podatku do odprowadzenia do urzędu skarbowego");
                    podatki[14] = new Kwota("Zaliczka podatku do odprowadzenia do urzędu skarbowego (wynagrodzenia)");
                    podatki[15] = new Kwota("Zaliczka podatku do odprowadzenia do urzędu skarbowego (zasiłki)");
                    podatki[16] = new Kwota("Zaliczka podatku do odprowadzenia do urzędu skarbowego (RAZEM)");
                    podatki[17] = new Kwota("Zaliczka do odprowadzenia do urzędu skarbowego (PIT-4R)");
                    podatki[18] = new Kwota("Podatek do odprowadzenia do urzędu skarbowego (PIT-8AR)");
                    podatki[19] = new Kwota("Zaliczka lub podatek do odprowadzenia do urzędu skarbowego (pozostałe deklaracje)");
            }

                void AddPłatności(Wyplata wypłata) {
                    string symbol = wypłata.WartoscCy.Symbol;
                    Wypłata w;
                    if (!wypłatyDct.TryGetValue(symbol, out w)) {
                        wypłatyDct.Add(symbol, w = new Wypłata(symbol));
                        wypłaty.Add(w);
                    }
                    w.Add(wypłata);
                }

                public void Update() {
                    if (wypłaty.Count == 1 && wypłaty[0].Waluta == Currency.SystemSymbol) 
                        wypłaty[0].lp = 1;
                    else {
                        Currency przelew = Currency.Zero;
                        Currency gotówka = Currency.Zero;
                        int lp = 0;
                        foreach (Wypłata w in wypłaty) {
                            w.lp = ++lp;
                            przelew += w.przelewPLN;
                            gotówka += w.gotówkaPLN;
                        }

                        wypłaty.Add(new Wypłata("<strong>Razem PLN</strong>", gotówka, przelew));
                    }
                }
                
                public void Add(ListaPlac lista) {
                    if (listy == "")
                        listy = "" + lista.Numer;
                    else
                        listy += "</b>;<b> " + lista.Numer;
                    clisty++;
                    foreach (Wyplata wyplata in lista.Wyplaty) {
                        cwyplaty++;
                        pracownicy[wyplata.Pracownik] = null;
                        AddPłatności(wyplata);
                        foreach (WypElement element in wyplata.Elementy) {
                            KodRSA rsa = element.KodRSA;
                            celementy++;
                            TotalKey key;
                            string nazwa;
                            if (srpars.AkordWgDef && element is WypElementAkord) {
                                WypElementAkord wea = (WypElementAkord)element;
                                nazwa = element.Definicja.Nazwa + "/" + wea.Akord.Definicja.Nazwa;
                                key = new TotalKey(wea.Akord.Definicja.Algorytm.Element);
                            }
                            else {
                                nazwa = element.Definicja.Nazwa;
                                key = new TotalKey(element);
                            }

                            Total total;
                            if (!ht.TryGetValue(key, out total))
                                ht.Add(key, total = new Total(element, nazwa));
                            total.Add(element);
                            Podatki p = element.Podatki;
                            składkiZUS[0].Add(p.Emerytalna);
                            składkiZUS[1].Add(p.Rentowa);
                            składkiZUS[2].Add(p.Chorobowa);
                            składkiZUS[3].Add(p.Wypadkowa);
                            składkiNFZ[0].Add(p.Zdrowotna.Podstawa, p.Zdrowotna.Prac, p.Zdrowotna.Firma);
                            if (!element.ZasiłekBudżet && !element.ZasiłekZus && element.Definicja.Deklaracje.Zdrowotne.Typ != TypUbezpieczeniaZdrowotnego.NieNaliczać)
                                składkiNFZ[1].Add(element.DoOpodatkowania - p.PomnKosztyZUS - p.Przychod26, p.ZdrowotneDoOdliczenia, 0m);
                            składkiPPK[0].Add(p.PPK.Podstawa, p.PPK.Pracownika, p.PPK.Pracodawcy);

                            składkiPoz[0].Add(p.FP);
                            składkiPoz[1].Add(p.FGSP);
                            składkiPoz[2].Add(p.FEP);

                            //if (element.Definicja.Info.Opodatkowany)
                                //podatki[0].Add(element.Wartosc);
                            podatki[0].Add(element.DoOpodatkowania);        //TID: 9544
                            podatki[1].Add(element.Podatki.Przychod26); 
                            if (element.PodstawaFIS)
                                podatki[2].Add(p.PomnKosztyZUS);
                            //else
                                podatki[3].Add(p.KosztyZUS-p.PomnKosztyZUS);
                            podatki[4].Add(p.KosztyZUS);
                            podatki[5].Add(p.Koszty + p.Koszty50);
                            podatki[7].Add(p.Ulga);
                            podatki[8].Add(p.NalFIS);

                            if (!element.ZasiłekBudżet && !element.ZasiłekZus) {
                                podatki[9].Add(p.NalFIS);
                                podatki[14].Add(p.ZalFIS);
                            }
                            else {
                                podatki[10].Add(p.NalFIS);
                                podatki[15].Add(p.ZalFIS);
                            }
                            podatki[11].Add(p.ZdrowotneDoOdliczenia);
                            podatki[12].Add(p.Zaniechanie);
                            podatki[13].Add(p.ZalFIS);
                            podatki[16].Add(p.ZalFIS);

                            if (p.VAT.DefinicjaStawki != null) {
                                PodsumowanieVAT ep;
                                if (!podsumowanieVAT.TryGetValue(p.VAT.DefinicjaStawki, out ep))
                                    podsumowanieVAT.Add(p.VAT.DefinicjaStawki, ep = new PodsumowanieVAT(p.VAT.DefinicjaStawki));
                                ep.Add(element);
                            }

                        //TID: 6318
                        if (p.ZalFIS != 0m) {
                            PozycjaPIT pozpit = element.Definicja.Deklaracje.PozycjaPIT;
                            if (pozpit != null)
                                if (pozpit.PIT8AR > 0 && element.Podatek)
                                    podatki[18].Add(p.ZalFIS);
                                else if (pozpit.PIT4R > 0 && element.ZaliczkaPodatku)
                                    podatki[17].Add(p.ZalFIS);
                                else
                                    podatki[19].Add(p.ZalFIS);
                        }

                            podatki[6].Add(p.PPK.Pracodawcy);
                        }
                    }
                    ppk |= JestPPK(lista, lista.DataWyplaty);
                }

                void Recalc() {
                    if (opodatkowaneZUS == null) {
                        opodatkowaneZUS = new ArrayList();
                        opodatkowaneZdrow = new ArrayList();
                        opodatkowane = new ArrayList();
                        zasiłki = new ArrayList();
                        nieOpodatkowanePodst = new ArrayList();
                        nieOpodatkowane = new ArrayList();
                        nieOpZasiłki = new ArrayList();

                        foreach (Total total in ht.Values) {
                            if (total.PodstawaFIS) {
                                if (total.Zasiłek) {
                                    zasiłki.Add(total);
                                    nieOpZasiłki.Add(total);
                                }
                                else {
                                    if (!srpars.OpodatWgSkł || total.PodstawaZUS)
                                        opodatkowaneZUS.Add(total);
                                    else if (total.PodstawaZdrow)
                                        opodatkowaneZdrow.Add(total);
                                    else
                                        opodatkowane.Add(total);
                                    if (total.DoOpodatkowania > 0)
                                        nieOpodatkowanePodst.Add(total);
                                    else
                                        nieOpodatkowane.Add(total);
                                }
                            }
                            else if (total.Zasiłek)
                                nieOpZasiłki.Add(total);
                            else {
                                if (total.DoOpodatkowania > 0)
                                    nieOpodatkowanePodst.Add(total);
                                else
                                    nieOpodatkowane.Add(total);
                            }
                              sumaPrzychod26 += total.Przychod26;
                        }
                        
                        opodatkowaneZUS.Sort();
                        opodatkowaneZdrow.Sort();
                        opodatkowane.Sort();
                        zasiłki.Sort();
                        nieOpodatkowanePodst.Sort();
                        nieOpodatkowane.Sort();
                        nieOpZasiłki.Sort();

                        podatekVAT = new List<PodsumowanieVAT>(podsumowanieVAT.Values);
                        podatekVAT.Sort();
                    }
                }

                public string Opis {
                    get {
                        if (lista == null) {
                            if (maxOpisLen == -1) {
                                if (pars.TylkoPodsumowanie)
                                    return "";
                                else
                                    return "<p>Podsumowanie list płac</p>";
                            }
                            if (maxOpisLen != 0 && listy.Length > maxOpisLen)
                                listy = listy.Substring(0, maxOpisLen - 3) + "...";
                            return "<p>Podsumowanie list płac: <b>" + listy + "</b></p>";
                        }
                        return "<p>Lista: <b>" + lista.Numer + "</b>, z dnia: <b>" + lista.Data + "</b>, za okres: <b>" + lista.Okres + "</b><br>Wydział: <b>" + lista.Wydzial.Kod + "</b></p>";
                    }
                }

                public Składka[] SkłZUS {
                    get { return składkiZUS; }
                }
                public Składka[] SkłNFZ {
                    get { return składkiNFZ; }
                }
                public Składka[] SkłPPK {
                    get { return składkiPPK; }
                }
                public Składka[] SkłPoz {
                    get { return składkiPoz; }
                }
                public Kwota[] Podatki {
                    get {
                        Kwota[] p = CopyArray(podatki);
                        p[6] = p[12] = p[13] = null;
                        if (!srpars.SzczegółowyPodatekNaliczony)
                        //    p[8] = null;
                        //else
                            p[9] = p[10] = null;
                        if (!srpars.SzczegółowyPodatekNależny)
                        //    p[16] = null;
                        //else
                            p[14] = p[15] = null;
                        //if (!ppk) p[6] = null;
                        p = CopyArray(p);
                        return p;
                    }
                }
                static Kwota[] CopyArray(Kwota[] src) {
                    int c = 0;
                    foreach (Kwota obj in src)
                        if (obj != null)
                            c++;
                    Kwota[] dest = new Kwota[c];
                    c = 0;
                    foreach (Kwota obj in src)
                        if (obj != null)
                            dest[c++] = obj;
                    return dest;
                }

                public Wypłata[] Wypłaty {
                    get { return wypłaty.ToArray(); }
                }
                public LiczbaElementow[] Liczby {
                    get {
                        if (lista != null)
                            return new LiczbaElementow[] { 
							new LiczbaElementow("Pracownicy", pracownicy.Count),
							new LiczbaElementow("Wypłaty", cwyplaty), 
							new LiczbaElementow("Elementy", celementy)
						};
                        return new LiczbaElementow[] { 
							new LiczbaElementow("Listy płac", clisty), 
							new LiczbaElementow("Pracownicy", pracownicy.Count),
							new LiczbaElementow("Wypłaty", cwyplaty), 
							new LiczbaElementow("Elementy", celementy)
						};
                    }
                }
                public ICollection Opodatkowane {
                    get {
                        Recalc();
                        return opodatkowane;
                    }
                }
                public ICollection OpodatkowaneZUS {
                    get {
                        Recalc();
                        return opodatkowaneZUS;
                    }
                }
                public ICollection OpodatkowaneZdrow {
                    get {
                        Recalc();
                        return opodatkowaneZdrow;
                    }
                }
                public ICollection Zasiłki {
                    get {
                        Recalc();
                        return zasiłki;
                    }
                }
                public ICollection NieOpodatkowanePodst {
                    get {
                        Recalc();
                        return nieOpodatkowanePodst;
                    }
                }
                public ICollection NieOpodatkowane {
                    get {
                        Recalc();
                        return nieOpodatkowane;
                    }
                }
                public ICollection NieOpZasiłki {
                    get {
                        Recalc();
                        return nieOpZasiłki;
                    }
                }
                public ICollection PodatekVAT {
                    get {
                        Recalc();
                        return podatekVAT;
                    }
                }
                public bool PPK {
                    get {
                        return ppk;
                    }
                }

                public decimal SumaPrzychod26 {
                    get {
                        return sumaPrzychod26;
                    }
                }
            }

            public class PrnParams : ContextBase {
                public PrnParams(Context context) : base(context) {
                }
                bool tylkoPodsumowanie = true;
                [Soneta.Types.Caption("Tylko podsumowanie")]
                public bool TylkoPodsumowanie {
                    set { tylkoPodsumowanie = value; }
                    get { return tylkoPodsumowanie; }
                }
            }

            public class SrParams : SerializableContextBase {
                public SrParams(Context context) : base(context) {
                }

                //Wypłaty za akordy mają być drukowane z podziałem na definicje akordów
                //static bool akordWgDef = false;
                bool akordWgDef = false;
                [Priority(1)]
                [Caption("Akordy wg definicji")]
                public bool AkordWgDef {
                    get { return akordWgDef; }
                    set {
                        akordWgDef = value;
                        OnChanged(EventArgs.Empty);
                    }
                }
                
                //Elementy opodatkowane stanowiące podstawę składek na ubezpieczenia społeczne, zdrowotne i nie
                //stanowiące podstawy składek mają być wykazywane osobno (true) lub razem (false)
                //static bool opodatWgSkł = true;
                bool opodatWgSkł = true;
                [Priority(2)]
                [Caption("Opodatk. wg składki")]
                public bool OpodatWgSkł {
                    get { return opodatWgSkł; }
                    set {
                        opodatWgSkł = value;
                        OnChanged(EventArgs.Empty);
                    }
                }
                
                //Podatek naliczony (przed odjęciem składki zdrowotnej i zaokrągleniem) w rozbicu na podatek
                //od wynagrodzeń i od zasiłków        
                //static bool szczegółowyPodatekNaliczony = true;
                bool szczegółowyPodatekNaliczony = true;
                [Priority(3)]
                [Caption("Naliczony szcz. podatek")]
                public bool SzczegółowyPodatekNaliczony {
                    get { return szczegółowyPodatekNaliczony; }
                    set {
                        szczegółowyPodatekNaliczony = value;
                        OnChanged(EventArgs.Empty);
                    }
                }
                
                //Podatek należny (do odprowadzenia do urzędu skarbowego) w rozbicu na podatek
                //od wynagrodzeń i od zasiłków        
                //static bool szczegółowyPodatekNależny = true;
                bool szczegółowyPodatekNależny = true;
                [Priority(4)]
                [Caption("Należny szcz. podatek")]
                public bool SzczegółowyPodatekNależny {
                    get { return szczegółowyPodatekNależny; }
                    set {
                        szczegółowyPodatekNależny = value;
                        OnChanged(EventArgs.Empty);
                    }
                }
            }		
		    
            PrnParams pars = null;
            [Context(Required = true)]
            public PrnParams Params {
                get { return pars; }
                set { pars = value; }
            }

            SrParams srpars;
            [SettingsContext]
            public SrParams SrPars {
                get { return srpars; }
                set { srpars = value; }
            }		

            void OnContextLoad(Object sender, EventArgs args) {
                if (!srpars.OpodatWgSkł)
                    colOpodInfo.Caption = "Opodatkowane elementy wynagrodzenia";

                ArrayList podsumowania = new ArrayList();
                Podsumowanie razem = new Podsumowanie(null, pars, srpars);
                Row[] rows = (Row[])dc.Get(typeof(Row[]));
                foreach (ListaPlac lista in rows) {
                    razem.Add(lista);
                    if (!pars.TylkoPodsumowanie) {
                        Podsumowanie pl = new Podsumowanie(lista, pars, srpars);
                        pl.Add(lista);
                        pl.Update();
                        podsumowania.Add(pl);
                    }
                }
                razem.Update();

                podsumowania.Add(razem);

                DataRepeater1.DataSource = podsumowania;
            }

            void DataRepeater1_BeforeRow(Object sender, EventArgs args) {
                Podsumowanie podsumowanie = (Podsumowanie)DataRepeater1.CurrentRow;
                Update(podsumowanie.OpodatkowaneZdrow, Grid5, dlOpodatZdrow, true);
                Update(podsumowanie.Opodatkowane, Grid8, dlOpodat, true);
                Update(podsumowanie.Zasiłki, Grid2, dlZasOpodat, true);
                Update(podsumowanie.NieOpodatkowanePodst, Grid31, dlNieopodatPodst, false);
                Update(podsumowanie.NieOpodatkowane, Grid3, dlNieopodat, false);
                Update(podsumowanie.NieOpZasiłki, Grid4, dlZasNieOp, false);
                Update(podsumowanie.PodatekVAT.Count>0, Grid9, dlPodatekVAT);
                sectionPPK.Visible = podsumowanie.PPK;
            }

            static void Update(ICollection c, Grid grid, DataLabel label, bool opodat) {
                bool any = false;
                foreach (Total t in c) {
                    if (opodat)
                        any = t.LiczbaOP > 0;
                    else
                        any = t.LiczbaNp > 0;
                    if (any)
                        break;
                }
                Update(any, grid, label);
            }

            static void Update(bool visible, Grid grid, DataLabel label) {
                if (visible) {
                    grid.Visible = true;
                    label.EditValue = "<p/>";
                }
                else {
                    grid.Visible = false;
                    label.EditValue = "";
                }
            }
		    
            static void Msg(object value) {
            }

            protected void Grid5_BeforeRow(object sender, RowEventArgs args) {
                Total t = (Total)args.Row;
                args.VisibleRow &= t.LiczbaOP != 0;
            }

            protected void Grid1_BeforeRow(object sender, RowEventArgs args) {
                Total t = (Total)args.Row;
                args.VisibleRow &= t.LiczbaOP != 0;
                //suma26 = t.Przychod26;
                //labelp26.EditValue += t.Przychod26;
            }

            protected void Grid8_BeforeRow(object sender, RowEventArgs args) {
                Total t = (Total)args.Row;
                args.VisibleRow &= t.LiczbaOP != 0;
            }

            protected void Grid2_BeforeRow(object sender, RowEventArgs args) {
                Total t = (Total)args.Row;
                args.VisibleRow &= t.LiczbaOP != 0;
            }

            protected void Grid31_BeforeRow(object sender, RowEventArgs args) {
                Total t = (Total)args.Row;
                args.VisibleRow &= t.LiczbaNp != 0;
            }

            protected void Grid3_BeforeRow(object sender, RowEventArgs args) {
                Total t = (Total)args.Row;
                args.VisibleRow &= t.LiczbaNp != 0;
            }

            protected void Grid4_BeforeRow(object sender, RowEventArgs args) {
                Total t = (Total)args.Row;
                args.VisibleRow &= t.LiczbaNp != 0;
            }
		    
</script>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
		<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<body>
		<form id="ZestawienieListPłac" method="post" runat="server">
			<ea:datacontext id="dc" runat="server" oncontextload="OnContextLoad"></ea:datacontext>
			<cc1:ReportHeader NagłówekOddziału="NagłówekOddziału" id="ReportHeader1" title="Zestawienie list płac|</strong>Typ: <strong>{0}|</strong>Okres: <strong>{1}"
				runat="server" DataMember0="ListyPlacViewInfo+Params.Typ" DataMember1="ListyPlacViewInfo+Params.Okres"></cc1:ReportHeader>
			<ea:datarepeater id="DataRepeater1" runat="server" Height="357px" Width="100%" OnBeforeRow="DataRepeater1_BeforeRow">
				<ea:SectionMarker id="SectionMarker1" runat="server"></ea:SectionMarker>
				<ea:PageBreak id="PageBreak1" runat="server" BreakFirstTimes="False"></ea:PageBreak>
				<P><FONT face="Tahoma" size="2">
						<ea:DataLabel id="DataLabel1" runat="server" DataMember="Opis" Bold="False"></ea:DataLabel></FONT>
					<ea:grid id="Grid1" runat="server" DataMember="OpodatkowaneZUS" 
                        onbeforerow="Grid1_BeforeRow">
						<Columns>
							<ea:GridColumn Width="4" Align="Right" DataMember="#" Caption=" "></ea:GridColumn>
							<ea:GridColumn DataMember="Nazwa" Caption="Opodatkowane elementy wynagrodzenia (podst. ubezp. społecznych pom. podst. opodatkowania)"
								ID="colOpodInfo"></ea:GridColumn>
							<ea:GridColumn Width="10" Align="Right" DataMember="LiczbaOP" Total="Sum" 
                                Caption="Liczba"></ea:GridColumn>
							<ea:GridColumn Width="15" Align="Right" DataMember="DodatkiOP" Total="Sum" 
                                Caption="Dodatki" HideZero="True"
								Format="{0:n}"></ea:GridColumn>
							<ea:GridColumn Width="15" Align="Right" DataMember="PotrąceniaOP" Total="Sum" Caption="Potrącenia"
								HideZero="True" Format="{0:n}"></ea:GridColumn>
							<ea:GridColumn Width="15" Align="Right" DataMember="RazemOP" Total="Sum" Caption="Razem"
								HideZero="True" Format="{0:n}"></ea:GridColumn>
						</Columns>
					</ea:grid>
                      <table style="FONT-SIZE: 8pt; FONT-FAMILY: Tahoma; BORDER-COLLAPSE: collapse" borderColor="silver" width="100%" border="1">
					<tbody>
						<tr>
							<td align="Center"><b>Przychód zw. art. 21 u.1 p.148 Suma: </b></td>
							<td align="Right" width="90"><b><ea:datalabel id="labelp26" DataMember="SumaPrzychod26" runat="server" Format="{0:n}"></ea:datalabel></b></td>
                            <td align="Right" Width="182"></td>
						</tr>
                    </tbody>
                 </table>
				<P></P>
				<ea:PageBreak id="Pagebreak12" runat="server" Required="False"></ea:PageBreak>
				<ea:grid id="Grid5" runat="server" DataMember="OpodatkowaneZdrow" 
                        onbeforerow="Grid5_BeforeRow">
					<Columns>
						<ea:GridColumn Width="4" Align="Right" DataMember="#" Caption=" "></ea:GridColumn>
						<ea:GridColumn DataMember="Nazwa" Caption="Opodatkowane elementy wynagrodzenia (podst. ubezp. zdrowotnego)"></ea:GridColumn>
						<ea:GridColumn Width="10" Align="Right" DataMember="LiczbaOP" Total="Sum" Caption="Liczba"></ea:GridColumn>
						<ea:GridColumn Width="15" Align="Right" DataMember="DodatkiOP" Total="Sum" Caption="Dodatki" HideZero="True"
							Format="{0:n}"></ea:GridColumn>
						<ea:GridColumn Width="15" Align="Right" DataMember="PotrąceniaOP" Total="Sum" Caption="Potrącenia"
							HideZero="True" Format="{0:n}"></ea:GridColumn>
						<ea:GridColumn Width="15" Align="Right" DataMember="RazemOP" Total="Sum" Caption="Razem"
							HideZero="True" Format="{0:n}"></ea:GridColumn>
					</Columns>
				</ea:grid>
				<ea:DataLabel id="dlOpodatZdrow" runat="server" Bold="False"></ea:DataLabel>
				<ea:PageBreak id="Pagebreak11" runat="server" Required="False"></ea:PageBreak>
				<ea:grid id="Grid8" runat="server" DataMember="Opodatkowane" 
                        onbeforerow="Grid8_BeforeRow">
					<Columns>
						<ea:GridColumn Width="4" Align="Right" DataMember="#" Caption=" "></ea:GridColumn>
						<ea:GridColumn DataMember="Nazwa" Caption="Opodatkowane elementy wynagrodzenia (pozostałe)"></ea:GridColumn>
						<ea:GridColumn Width="10" Align="Right" DataMember="LiczbaOP" Total="Sum" 
                            Caption="Liczba"></ea:GridColumn>
						<ea:GridColumn Width="15" Align="Right" DataMember="DodatkiOP" Total="Sum" 
                            Caption="Dodatki" HideZero="True"
							Format="{0:n}"></ea:GridColumn>
						<ea:GridColumn Width="15" Align="Right" DataMember="PotrąceniaOP" Total="Sum" Caption="Potrącenia"
							HideZero="True" Format="{0:n}"></ea:GridColumn>
						<ea:GridColumn Width="15" Align="Right" DataMember="RazemOP" Total="Sum" Caption="Razem"
							HideZero="True" Format="{0:n}"></ea:GridColumn>
					</Columns>
				</ea:grid>
				<ea:DataLabel id="dlOpodat" runat="server" Bold="False"></ea:DataLabel>
				<ea:PageBreak id="PageBreak10" runat="server" Required="False"></ea:PageBreak>
				<ea:grid id="Grid2" runat="server" DataMember="Zasiłki" WithSections="False" 
                        onbeforerow="Grid2_BeforeRow">
					<Columns>
						<ea:GridColumn Width="4" Align="Right" DataMember="#" Caption=" "></ea:GridColumn>
						<ea:GridColumn DataMember="Nazwa" Caption="Opodatkowane zasiłki"></ea:GridColumn>
						<ea:GridColumn Width="10" Align="Right" DataMember="LiczbaOP" Total="Sum" 
                            Caption="Liczba"></ea:GridColumn>
						<ea:GridColumn Width="15" Align="Right" DataMember="DodatkiOP" Total="Sum" 
                            Caption="Dodatki" HideZero="True"
							Format="{0:n}"></ea:GridColumn>
						<ea:GridColumn Width="15" Align="Right" DataMember="PotrąceniaOP" Total="Sum" Caption="Potrącenia"
							HideZero="True" Format="{0:n}"></ea:GridColumn>
						<ea:GridColumn Width="15" Align="Right" DataMember="RazemOP" Total="Sum" Caption="Razem"
							HideZero="True" Format="{0:n}"></ea:GridColumn>
					</Columns>
				</ea:grid>
				<ea:DataLabel id="dlZasOpodat" runat="server" Bold="False"></ea:DataLabel>
				<ea:PageBreak id="PageBreak9" runat="server" Required="False"></ea:PageBreak>
				<ea:grid id="Grid31" runat="server" DataMember="NieOpodatkowanePodst" 
                        WithSections="False" onbeforerow="Grid31_BeforeRow">
					<Columns>
						<ea:GridColumn Width="4" Align="Right" DataMember="#" Caption=" "></ea:GridColumn>
						<ea:GridColumn DataMember="Nazwa" Caption="Nieopodatkowane elementy wynagrodzenia (podst. ubezp. społecznych nie pom. podst. opodatkowania)"></ea:GridColumn>
						<ea:GridColumn Width="10" Align="Right" DataMember="LiczbaNp" Total="Sum" 
                            Caption="Liczba"></ea:GridColumn>
						<ea:GridColumn Width="15" Align="Right" DataMember="DodatkiNp" Total="Sum" 
                            Caption="Dodatki" HideZero="True"
							Format="{0:n}"></ea:GridColumn>
						<ea:GridColumn Width="15" Align="Right" DataMember="PotrąceniaNp" Total="Sum" Caption="Potrącenia"
							HideZero="True" Format="{0:n}"></ea:GridColumn>
						<ea:GridColumn Width="15" Align="Right" DataMember="RazemNp" Total="Sum" Caption="Razem"
							HideZero="True" Format="{0:n}"></ea:GridColumn>
					</Columns>
				</ea:grid>
				<ea:DataLabel id="dlNieopodatPodst" runat="server" Bold="False"></ea:DataLabel>
				<ea:PageBreak id="PageBreak14" runat="server" Required="False"></ea:PageBreak>
				<ea:grid id="Grid3" runat="server" DataMember="NieOpodatkowane" 
                        WithSections="False" onbeforerow="Grid3_BeforeRow">
					<Columns>
						<ea:GridColumn Width="4" Align="Right" DataMember="#" Caption=" "></ea:GridColumn>
						<ea:GridColumn DataMember="Nazwa" Caption="Nieopodatkowane elementy wynagrodzenia"></ea:GridColumn>
						<ea:GridColumn Width="10" Align="Right" DataMember="LiczbaNp" Total="Sum" 
                            Caption="Liczba"></ea:GridColumn>
						<ea:GridColumn Width="15" Align="Right" DataMember="DodatkiNp" Total="Sum" 
                            Caption="Dodatki" HideZero="True"
							Format="{0:n}"></ea:GridColumn>
						<ea:GridColumn Width="15" Align="Right" DataMember="PotrąceniaNp" Total="Sum" Caption="Potrącenia"
							HideZero="True" Format="{0:n}"></ea:GridColumn>
						<ea:GridColumn Width="15" Align="Right" DataMember="RazemNp" Total="Sum" Caption="Razem"
							HideZero="True" Format="{0:n}"></ea:GridColumn>
					</Columns>
				</ea:grid>
				<ea:DataLabel id="dlNieopodat" runat="server" Bold="False"></ea:DataLabel>
				<ea:PageBreak id="PageBreak8" runat="server" Required="False"></ea:PageBreak>
				<ea:grid id="Grid4" runat="server" DataMember="NieOpZasiłki" WithSections="False" 
                        onbeforerow="Grid4_BeforeRow">
					<Columns>
						<ea:GridColumn Width="4" Align="Right" DataMember="#" Caption=" "></ea:GridColumn>
						<ea:GridColumn DataMember="Nazwa" Caption="Nieopodatkowane zasiłki"></ea:GridColumn>
						<ea:GridColumn Width="10" Align="Right" DataMember="LiczbaNp" Total="Sum" 
                            Caption="Liczba"></ea:GridColumn>
						<ea:GridColumn Width="15" Align="Right" DataMember="DodatkiNp" Total="Sum" 
                            Caption="Dodatki" Format="{0:n}"></ea:GridColumn>
						<ea:GridColumn Width="15" Align="Right" DataMember="PotrąceniaNp" Total="Sum" Caption="Potrącenia"
							Format="{0:n}"></ea:GridColumn>
						<ea:GridColumn Width="15" Align="Right" DataMember="RazemNp" Total="Sum" Caption="Razem"
							Format="{0:n}"></ea:GridColumn>
					</Columns>
				</ea:grid>
				<ea:DataLabel id="dlZasNieOp" runat="server" Bold="False"></ea:DataLabel>
				<ea:PageBreak id="PageBreak7" runat="server" Required="False"></ea:PageBreak>
				<ea:grid id="gridSklSpol" runat="server" DataMember="SkłZUS" WithSections="False">
					<Columns>
						<ea:GridColumn Width="4" Align="Right" DataMember="#" Caption=" "></ea:GridColumn>
						<ea:GridColumn DataMember="Nazwa" Caption="Składki na ubezpieczenia społeczne"></ea:GridColumn>
						<ea:GridColumn Width="15" Align="Right" DataMember="Podstawa" Caption="Podstawa" HideZero="True"
							Format="{0:n}"></ea:GridColumn>
						<ea:GridColumn Width="15" Align="Right" DataMember="Prac" Total="Sum" Caption="Ubezpieczony" HideZero="True"
							Format="{0:n}"></ea:GridColumn>
						<ea:GridColumn Width="15" Align="Right" DataMember="Firma" Total="Sum" Caption="Płatnik" HideZero="True"
							Format="{0:n}"></ea:GridColumn>
						<ea:GridColumn Width="15" Align="Right" DataMember="Razem" Total="Sum" Format="{0:n}"></ea:GridColumn>
					</Columns>
				</ea:grid>
				<P></P>
				<ea:PageBreak id="PageBreak6" runat="server" Required="False"></ea:PageBreak>
				<ea:grid id="gridSklZdrow" runat="server" DataMember="SkłNFZ" WithSections="False">
					<Columns>
						<ea:GridColumn Width="4" Align="Right" DataMember="#" Caption=" "></ea:GridColumn>
						<ea:GridColumn DataMember="Nazwa" Caption="Składka na ubezpieczenie zdrowotne"></ea:GridColumn>
						<ea:GridColumn Width="15" Align="Right" DataMember="Podstawa" Caption="Podstawa" HideZero="True"
							Format="{0:n}"></ea:GridColumn>
						<ea:GridColumn Width="15" Align="Right" DataMember="Prac" Caption="Ubezpieczony" HideZero="True"
							Format="{0:n}"></ea:GridColumn>
						<ea:GridColumn Width="15" Align="Right" DataMember="Firma" Caption="Płatnik" HideZero="True" Format="{0:n}"></ea:GridColumn>
						<ea:GridColumn Width="15" Align="Right" DataMember="Razem" HideZero="True" Format="{0:n}"></ea:GridColumn>
					</Columns>
				</ea:grid>
                <ea:Section runat="server" ID="sectionPPK">
				    <P></P>
				    <ea:PageBreak id="PageBreak15" runat="server" Required="False"></ea:PageBreak>
				    <ea:grid id="grid10" runat="server" DataMember="SkłPPK" WithSections="False">
					    <Columns>
						    <ea:GridColumn Width="4" Align="Right" DataMember="#" Caption=" "></ea:GridColumn>
						    <ea:GridColumn DataMember="Nazwa" Caption="Składki PPK"></ea:GridColumn>
						    <ea:GridColumn Width="15" Align="Right" DataMember="Podstawa" Caption="Podstawa" HideZero="True"
							    Format="{0:n}"></ea:GridColumn>
						    <ea:GridColumn Width="15" Align="Right" DataMember="Prac" Total="Sum" Caption="Ubezpieczony" HideZero="True"
							    Format="{0:n}"></ea:GridColumn>
						    <ea:GridColumn Width="15" Align="Right" DataMember="Firma" Total="Sum" Caption="Płatnik" HideZero="True"
							    Format="{0:n}"></ea:GridColumn>
						    <ea:GridColumn Width="15" Align="Right" DataMember="Razem" Total="Sum" HideZero="True" Format="{0:n}"></ea:GridColumn>
					    </Columns>
				    </ea:grid>
                </ea:Section>

				<P></P>
				<ea:PageBreak id="PageBreak5" runat="server" Required="False"></ea:PageBreak>
				<ea:grid id="gridSklPoz" runat="server" DataMember="SkłPoz" WithSections="False">
					<Columns>
						<ea:GridColumn Width="4" Align="Right" DataMember="#" Caption=" "></ea:GridColumn>
						<ea:GridColumn DataMember="Nazwa" Caption="Pozostałe składki"></ea:GridColumn>
						<ea:GridColumn Width="15" Align="Right" DataMember="Podstawa" Caption="Podstawa" HideZero="True"
							Format="{0:n}"></ea:GridColumn>
						<ea:GridColumn Width="15" Align="Right" DataMember="Prac" Total="Sum" Caption="Ubezpieczony" HideZero="True"
							Format="{0:n}"></ea:GridColumn>
						<ea:GridColumn Width="15" Align="Right" DataMember="Firma" Total="Sum" Caption="Płatnik" HideZero="True"
							Format="{0:n}"></ea:GridColumn>
						<ea:GridColumn Width="15" Align="Right" DataMember="Razem" Total="Sum" HideZero="True" Format="{0:n}"></ea:GridColumn>
					</Columns>
				</ea:grid>
				<P></P>
				<ea:PageBreak id="PageBreak13" runat="server" Required="False"></ea:PageBreak>
				<ea:grid id="Grid9" runat="server" DataMember="PodatekVAT" WithSections="False">
					<Columns>
						<ea:GridColumn Width="4" Align="Right" DataMember="#" Caption=" " runat="server"></ea:GridColumn>
						<ea:GridColumn DataMember="Stawka" Caption="Podatek VAT (stawka)" runat="server" Total="Info"></ea:GridColumn>
						<ea:GridColumn Width="15" Align="Right" DataMember="Netto" Format="{0:n}" Caption="Netto" runat="server" Total="Sum"></ea:GridColumn>
                        <ea:GridColumn runat="server" Align="Right" Caption="VAT" DataMember="VAT" Format="{0:n}"
                            Total="Sum" Width="15">
                        </ea:GridColumn>
                        <ea:GridColumn runat="server" Align="Right" Caption="Brutto" DataMember="Brutto"
                            Format="{0:n}" Total="Sum" Width="15">
                        </ea:GridColumn>
					</Columns>
				</ea:grid>
				<ea:DataLabel id="dlPodatekVAT" runat="server" Bold="False"></ea:DataLabel>
				<ea:PageBreak id="PageBreak4" runat="server" Required="False"></ea:PageBreak>
				<ea:grid id="Grid6" runat="server" DataMember="Podatki" WithSections="False">
					<Columns>
						<ea:GridColumn Width="4" Align="Right" DataMember="#" Caption=" "></ea:GridColumn>
						<ea:GridColumn DataMember="Nazwa" Caption="Podatki"></ea:GridColumn>
						<ea:GridColumn Width="15" Align="Right" DataMember="Wartość" HideZero="True" Format="{0:n}"></ea:GridColumn>
					</Columns>
				</ea:grid>
				<P></P>
				<ea:PageBreak id="PageBreak3" runat="server" Required="False"></ea:PageBreak>
				<ea:grid id="Grid7" runat="server" DataMember="Wypłaty" WithSections="False">
					<Columns>
						<ea:GridColumn Width="4" Align="Right" DataMember="Lp" Caption=" " 
                            HideZero="True"></ea:GridColumn>
						<ea:GridColumn Caption="Do wypłaty" DataMember="Info"></ea:GridColumn>
						<ea:GridColumn Width="15" Align="Right" DataMember="Got&#243;wka" 
                            HideZero="True"></ea:GridColumn>
						<ea:GridColumn Width="15" Align="Right" DataMember="Przelew" HideZero="True"></ea:GridColumn>
						<ea:GridColumn Width="15" Align="Right" DataMember="Razem" HideZero="True"></ea:GridColumn>
					</Columns>
				</ea:grid>
				<P></P>
				<ea:PageBreak id="PageBreak2" runat="server" Required="False"></ea:PageBreak>
				<ea:grid id="gridLiczby" runat="server" DataMember="Liczby" WithSections="False">
					<Columns>
						<ea:GridColumn Width="4" Align="Right" DataMember="#" Caption=" "></ea:GridColumn>
						<ea:GridColumn Width="30" DataMember="Opis" Caption="Podsumowanie"></ea:GridColumn>
						<ea:GridColumn Width="10" Align="Right" DataMember="Liczba"></ea:GridColumn>
					</Columns>
				</ea:grid>
				<ea:SectionMarker id="SectionMarker3" runat="server" SectionType="Footer"></ea:SectionMarker>
			</ea:datarepeater>
			<cc1:ReportFooter id="ReportFooter1" runat="server">
				<Subtitles>
					<cc1:FooterSubtitle SubtitleType="Operator"></cc1:FooterSubtitle>
					<cc1:FooterSubtitle Caption="Sporządził" SubtitleType="Podpis"></cc1:FooterSubtitle>
					<cc1:FooterSubtitle Caption="Sprawdził" SubtitleType="Podpis"></cc1:FooterSubtitle>
					<cc1:FooterSubtitle Caption="Zatwierdził" SubtitleType="Podpis"></cc1:FooterSubtitle>
				</Subtitles>
			</cc1:ReportFooter>
		</form>
	</body>
</HTML>
